<?php

namespace VM\ApiBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use FOS\RestBundle\Controller\Annotations\View;
use VM\ApiBundle\Entity\CompanyAllegroCategoryItem;
use VM\FinancialStatementsBundle\Services\Restrictions\SegmentRestrictions;
use VM\ApiBundle\Entity\SummaryCompanyRound;


class CompanyController extends AbstractController
{
    /**
     * @View(serializerGroups={"companyDetails"})
     */
    public function getCompanyAction()
    {
        $User = $this->getUser();
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);

        return $Company;
    }

    /**
     * @View()
     */
    public function checkRestrictionsAction($productionAmount)
    {
        /** @var SegmentRestrictions $SegmentRestrictions */
        $SegmentRestrictions = $this->get('segment.restrictions');

        $productionAmount = $productionAmount > 3000000? 3000000: $productionAmount;
        $SegmentRestrictions->setData($this->getUser()->getGroup()->getUser()->getmarketSegment(),$this->getApiGetter()->getUserCompanyOrFalse($this->getUser()));
        $SegmentRestrictions->setProductionAmount((int)$productionAmount);
        $SegmentRestrictions->generate();

        return $SegmentRestrictions->getResults();
    }

    /**
     * @View()
     */
    public function getInventoryAction()
    {
        $User = $this->getUser();
        $Company = $this->getApiGetter()->getUserCompanyOrFalse($User);
        
        if(empty($Company))
        {
            throw new \Exception('Company not exist', 1);
        }

        $CurrentRound = $this->getApiGetter()->getUserActualRound($User);
        $SummaryCompanyRounds = $Company->getSummaryCompanyRound();

        $SummaryCompanyRound = null;
        /** @var SummaryCompanyRound $summary */
        foreach($SummaryCompanyRounds as $summary)
        {
            if($summary->getRound()->getSequence() === $CurrentRound->getSequence()-1);
                $SummaryCompanyRound = $summary;
        }

        $inventory = (empty($SummaryCompanyRound)) ? 0 : $SummaryCompanyRound->getZapasy();

        return array('inventory'=>$inventory, 'round_id' => $CurrentRound->getId(), 'company_id' => $Company->getId());
    }

}
